<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportItem_V10 StructType
 * @subpackage Structs
 */
class ActivityReportItem_V10 extends ActivityReportItem_V9
{
    /**
     * The Soucre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Soucre;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for ActivityReportItem_V10
     * @uses ActivityReportItem_V10::setSoucre()
     * @uses ActivityReportItem_V10::setActive()
     * @param string $soucre
     * @param bool $active
     */
    public function __construct($soucre = null, $active = null)
    {
        $this
            ->setSoucre($soucre)
            ->setActive($active);
    }
    /**
     * Get Soucre value
     * @return string
     */
    public function getSoucre()
    {
        return $this->Soucre;
    }
    /**
     * Set Soucre value
     * @uses \EnumType\EnumSource::valueIsValid()
     * @uses \EnumType\EnumSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $soucre
     * @return \StructType\ActivityReportItem_V10
     */
    public function setSoucre($soucre = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSource::valueIsValid($soucre)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $soucre, implode(', ', \EnumType\EnumSource::getValidValues())), __LINE__);
        }
        $this->Soucre = $soucre;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ActivityReportItem_V10
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityReportItem_V10
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
