<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityPlace StructType
 * @subpackage Structs
 */
class ActivityPlace extends Activity
{
    /**
     * The MaxTimeOfExecution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxTimeOfExecution;
    /**
     * Constructor method for ActivityPlace
     * @uses ActivityPlace::setMaxTimeOfExecution()
     * @param int $maxTimeOfExecution
     */
    public function __construct($maxTimeOfExecution = null)
    {
        $this
            ->setMaxTimeOfExecution($maxTimeOfExecution);
    }
    /**
     * Get MaxTimeOfExecution value
     * @return int
     */
    public function getMaxTimeOfExecution()
    {
        return $this->MaxTimeOfExecution;
    }
    /**
     * Set MaxTimeOfExecution value
     * @param int $maxTimeOfExecution
     * @return \StructType\ActivityPlace
     */
    public function setMaxTimeOfExecution($maxTimeOfExecution = null)
    {
        // validation for constraint: int
        if (!is_null($maxTimeOfExecution) && !is_numeric($maxTimeOfExecution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxTimeOfExecution)), __LINE__);
        }
        $this->MaxTimeOfExecution = $maxTimeOfExecution;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityPlace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
