<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInfo StructType
 * @subpackage Structs
 */
class ActivityInfo extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The IsPlanning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsPlanning;
    /**
     * The ActivityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ActivityType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PathInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPath
     */
    public $PathInfos;
    /**
     * Constructor method for ActivityInfo
     * @uses ActivityInfo::setID()
     * @uses ActivityInfo::setIsPlanning()
     * @uses ActivityInfo::setActivityType()
     * @uses ActivityInfo::setName()
     * @uses ActivityInfo::setPathInfos()
     * @param int $iD
     * @param bool $isPlanning
     * @param string $activityType
     * @param string $name
     * @param \ArrayType\ArrayOfPath $pathInfos
     */
    public function __construct($iD = null, $isPlanning = null, $activityType = null, $name = null, \ArrayType\ArrayOfPath $pathInfos = null)
    {
        $this
            ->setID($iD)
            ->setIsPlanning($isPlanning)
            ->setActivityType($activityType)
            ->setName($name)
            ->setPathInfos($pathInfos);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ActivityInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IsPlanning value
     * @return bool
     */
    public function getIsPlanning()
    {
        return $this->IsPlanning;
    }
    /**
     * Set IsPlanning value
     * @param bool $isPlanning
     * @return \StructType\ActivityInfo
     */
    public function setIsPlanning($isPlanning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPlanning) && !is_bool($isPlanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPlanning)), __LINE__);
        }
        $this->IsPlanning = $isPlanning;
        return $this;
    }
    /**
     * Get ActivityType value
     * @return string
     */
    public function getActivityType()
    {
        return $this->ActivityType;
    }
    /**
     * Set ActivityType value
     * @uses \EnumType\EnumActivityType::valueIsValid()
     * @uses \EnumType\EnumActivityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityType
     * @return \StructType\ActivityInfo
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumActivityType::valueIsValid($activityType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $activityType, implode(', ', \EnumType\EnumActivityType::getValidValues())), __LINE__);
        }
        $this->ActivityType = $activityType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ActivityInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PathInfos value
     * @return \ArrayType\ArrayOfPath|null
     */
    public function getPathInfos()
    {
        return $this->PathInfos;
    }
    /**
     * Set PathInfos value
     * @param \ArrayType\ArrayOfPath $pathInfos
     * @return \StructType\ActivityInfo
     */
    public function setPathInfos(\ArrayType\ArrayOfPath $pathInfos = null)
    {
        $this->PathInfos = $pathInfos;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
