<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbsenceItem StructType
 * @subpackage Structs
 */
class AbsenceItem extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The DayCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DayCode
     */
    public $DayCode;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * Constructor method for AbsenceItem
     * @uses AbsenceItem::setDateTime()
     * @uses AbsenceItem::setDayCode()
     * @uses AbsenceItem::setDriver()
     * @param string $dateTime
     * @param \StructType\DayCode $dayCode
     * @param \StructType\IdentifierPerson_V2 $driver
     */
    public function __construct($dateTime = null, \StructType\DayCode $dayCode = null, \StructType\IdentifierPerson_V2 $driver = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setDayCode($dayCode)
            ->setDriver($driver);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\AbsenceItem
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get DayCode value
     * @return \StructType\DayCode|null
     */
    public function getDayCode()
    {
        return $this->DayCode;
    }
    /**
     * Set DayCode value
     * @param \StructType\DayCode $dayCode
     * @return \StructType\AbsenceItem
     */
    public function setDayCode(\StructType\DayCode $dayCode = null)
    {
        $this->DayCode = $dayCode;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\AbsenceItem
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbsenceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
