<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Absence StructType
 * @subpackage Structs
 */
class Absence extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The DayCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DayCode;
    /**
     * Constructor method for Absence
     * @uses Absence::setDateTime()
     * @uses Absence::setDayCode()
     * @param string $dateTime
     * @param string $dayCode
     */
    public function __construct($dateTime = null, $dayCode = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setDayCode($dayCode);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Absence
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get DayCode value
     * @return string|null
     */
    public function getDayCode()
    {
        return $this->DayCode;
    }
    /**
     * Set DayCode value
     * @param string $dayCode
     * @return \StructType\Absence
     */
    public function setDayCode($dayCode = null)
    {
        // validation for constraint: string
        if (!is_null($dayCode) && !is_string($dayCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dayCode)), __LINE__);
        }
        $this->DayCode = $dayCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Absence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
