<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Set_TemperatureSettings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Set_TemperatureSettings $parameters
     * @return \StructType\Set_TemperatureSettingsResponse|bool
     */
    public function Set_TemperatureSettings(\StructType\Set_TemperatureSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Set_TemperatureSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Set_SubcontractedVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Set_SubcontractedVehicles $parameters
     * @return \StructType\Set_SubcontractedVehiclesResponse|bool
     */
    public function Set_SubcontractedVehicles(\StructType\Set_SubcontractedVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Set_SubcontractedVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Set_SmsCommunicationConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Set_SmsCommunicationConfig $parameters
     * @return \StructType\Set_SmsCommunicationConfigResponse|bool
     */
    public function Set_SmsCommunicationConfig(\StructType\Set_SmsCommunicationConfig $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Set_SmsCommunicationConfig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Set_SmsCommunicationConfigResponse|\StructType\Set_SubcontractedVehiclesResponse|\StructType\Set_TemperatureSettingsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
