<?php

namespace EnumType;

/**
 * This class stands for enumViaRouteUpdateType EnumType
 * @subpackage Enumerations
 */
class EnumViaRouteUpdateType
{
    /**
     * Constant for value 'REMOVE_ALL_VIAPOINTS'
     * @return string 'REMOVE_ALL_VIAPOINTS'
     */
    const VALUE_REMOVE_ALL_VIAPOINTS = 'REMOVE_ALL_VIAPOINTS';
    /**
     * Constant for value 'UPDATE_CURRENT_VIAPOINTS'
     * @return string 'UPDATE_CURRENT_VIAPOINTS'
     */
    const VALUE_UPDATE_CURRENT_VIAPOINTS = 'UPDATE_CURRENT_VIAPOINTS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REMOVE_ALL_VIAPOINTS
     * @uses self::VALUE_UPDATE_CURRENT_VIAPOINTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REMOVE_ALL_VIAPOINTS,
            self::VALUE_UPDATE_CURRENT_VIAPOINTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
