<?php

namespace EnumType;

/**
 * This class stands for enumViaRouteType EnumType
 * @subpackage Enumerations
 */
class EnumViaRouteType
{
    /**
     * Constant for value 'INSTANT'
     * @return string 'INSTANT'
     */
    const VALUE_INSTANT = 'INSTANT';
    /**
     * Constant for value 'ROUTEPLANNER'
     * @return string 'ROUTEPLANNER'
     */
    const VALUE_ROUTEPLANNER = 'ROUTEPLANNER';
    /**
     * Constant for value 'PLANNING'
     * @return string 'PLANNING'
     */
    const VALUE_PLANNING = 'PLANNING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INSTANT
     * @uses self::VALUE_ROUTEPLANNER
     * @uses self::VALUE_PLANNING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INSTANT,
            self::VALUE_ROUTEPLANNER,
            self::VALUE_PLANNING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
