<?php

namespace EnumType;

/**
 * This class stands for enumViaRouteDeleteStatus EnumType
 * @subpackage Enumerations
 */
class EnumViaRouteDeleteStatus
{
    /**
     * Constant for value 'NOT_DELETED'
     * @return string 'NOT_DELETED'
     */
    const VALUE_NOT_DELETED = 'NOT_DELETED';
    /**
     * Constant for value 'SENDING_DELETION'
     * @return string 'SENDING_DELETION'
     */
    const VALUE_SENDING_DELETION = 'SENDING_DELETION';
    /**
     * Constant for value 'DELIVERED_DELETION'
     * @return string 'DELIVERED_DELETION'
     */
    const VALUE_DELIVERED_DELETION = 'DELIVERED_DELETION';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'REQUESTED_DELETION'
     * @return string 'REQUESTED_DELETION'
     */
    const VALUE_REQUESTED_DELETION = 'REQUESTED_DELETION';
    /**
     * Constant for value 'DELETION_CONFIRMED'
     * @return string 'DELETION_CONFIRMED'
     */
    const VALUE_DELETION_CONFIRMED = 'DELETION_CONFIRMED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_DELETED
     * @uses self::VALUE_SENDING_DELETION
     * @uses self::VALUE_DELIVERED_DELETION
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_REQUESTED_DELETION
     * @uses self::VALUE_DELETION_CONFIRMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_DELETED,
            self::VALUE_SENDING_DELETION,
            self::VALUE_DELIVERED_DELETION,
            self::VALUE_ERROR,
            self::VALUE_REQUESTED_DELETION,
            self::VALUE_DELETION_CONFIRMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
