<?php

namespace EnumType;

/**
 * This class stands for enumViaRouteBehavior EnumType
 * @subpackage Enumerations
 */
class EnumViaRouteBehavior
{
    /**
     * Constant for value 'SECURED_VIAROUTE'
     * @return string 'SECURED_VIAROUTE'
     */
    const VALUE_SECURED_VIAROUTE = 'SECURED_VIAROUTE';
    /**
     * Constant for value 'MAGNETIC_VIAROUTE'
     * @return string 'MAGNETIC_VIAROUTE'
     */
    const VALUE_MAGNETIC_VIAROUTE = 'MAGNETIC_VIAROUTE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SECURED_VIAROUTE
     * @uses self::VALUE_MAGNETIC_VIAROUTE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SECURED_VIAROUTE,
            self::VALUE_MAGNETIC_VIAROUTE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
