<?php

namespace EnumType;

/**
 * This class stands for enumValidatedHours EnumType
 * @subpackage Enumerations
 */
class EnumValidatedHours
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'VALIDATED_ONLY'
     * @return string 'VALIDATED_ONLY'
     */
    const VALUE_VALIDATED_ONLY = 'VALIDATED_ONLY';
    /**
     * Constant for value 'NOT_VALIDATED_ONLY'
     * @return string 'NOT_VALIDATED_ONLY'
     */
    const VALUE_NOT_VALIDATED_ONLY = 'NOT_VALIDATED_ONLY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_VALIDATED_ONLY
     * @uses self::VALUE_NOT_VALIDATED_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_VALIDATED_ONLY,
            self::VALUE_NOT_VALIDATED_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
