<?php

namespace EnumType;

/**
 * This class stands for enumTachoDataSource EnumType
 * @subpackage Enumerations
 */
class EnumTachoDataSource
{
    /**
     * Constant for value 'OBC'
     * @return string 'OBC'
     */
    const VALUE_OBC = 'OBC';
    /**
     * Constant for value 'TACHO'
     * @return string 'TACHO'
     */
    const VALUE_TACHO = 'TACHO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OBC
     * @uses self::VALUE_TACHO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OBC,
            self::VALUE_TACHO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
