<?php

namespace EnumType;

/**
 * This class stands for enumSynchronisationStatus EnumType
 * @subpackage Enumerations
 */
class EnumSynchronisationStatus
{
    /**
     * Constant for value 'NOT_TRANSFERRED'
     * @return string 'NOT_TRANSFERRED'
     */
    const VALUE_NOT_TRANSFERRED = 'NOT_TRANSFERRED';
    /**
     * Constant for value 'BUSY'
     * @return string 'BUSY'
     */
    const VALUE_BUSY = 'BUSY';
    /**
     * Constant for value 'DONE'
     * @return string 'DONE'
     */
    const VALUE_DONE = 'DONE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_TRANSFERRED
     * @uses self::VALUE_BUSY
     * @uses self::VALUE_DONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_TRANSFERRED,
            self::VALUE_BUSY,
            self::VALUE_DONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
