<?php

namespace EnumType;

/**
 * This class stands for enumPositionSource EnumType
 * @subpackage Enumerations
 */
class EnumPositionSource
{
    /**
     * Constant for value 'GPS'
     * @return string 'GPS'
     */
    const VALUE_GPS = 'GPS';
    /**
     * Constant for value 'GPRS'
     * @return string 'GPRS'
     */
    const VALUE_GPRS = 'GPRS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GPS
     * @uses self::VALUE_GPRS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GPS,
            self::VALUE_GPRS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
