<?php

namespace EnumType;

/**
 * This class stands for enumPlanningSelectionHistoricalType EnumType
 * @subpackage Enumerations
 */
class EnumPlanningSelectionHistoricalType
{
    /**
     * Constant for value 'PLANNING'
     * @return string 'PLANNING'
     */
    const VALUE_PLANNING = 'PLANNING';
    /**
     * Constant for value 'ANOMALY'
     * @return string 'ANOMALY'
     */
    const VALUE_ANOMALY = 'ANOMALY';
    /**
     * Constant for value 'COMMENTS'
     * @return string 'COMMENTS'
     */
    const VALUE_COMMENTS = 'COMMENTS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLANNING
     * @uses self::VALUE_ANOMALY
     * @uses self::VALUE_COMMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLANNING,
            self::VALUE_ANOMALY,
            self::VALUE_COMMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
