<?php

namespace EnumType;

/**
 * This class stands for enumPlanningActionType EnumType
 * @subpackage Enumerations
 */
class EnumPlanningActionType
{
    /**
     * Constant for value 'INSERT'
     * @return string 'INSERT'
     */
    const VALUE_INSERT = 'INSERT';
    /**
     * Constant for value 'FULL_UPDATE'
     * @return string 'FULL_UPDATE'
     */
    const VALUE_FULL_UPDATE = 'FULL_UPDATE';
    /**
     * Constant for value 'DIFFERENTIAL_UPDATE'
     * @return string 'DIFFERENTIAL_UPDATE'
     */
    const VALUE_DIFFERENTIAL_UPDATE = 'DIFFERENTIAL_UPDATE';
    /**
     * Constant for value 'DATABASE_UPDATE'
     * @return string 'DATABASE_UPDATE'
     */
    const VALUE_DATABASE_UPDATE = 'DATABASE_UPDATE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INSERT
     * @uses self::VALUE_FULL_UPDATE
     * @uses self::VALUE_DIFFERENTIAL_UPDATE
     * @uses self::VALUE_DATABASE_UPDATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INSERT,
            self::VALUE_FULL_UPDATE,
            self::VALUE_DIFFERENTIAL_UPDATE,
            self::VALUE_DATABASE_UPDATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
