<?php

namespace EnumType;

/**
 * This class stands for enumPathInfoReturnType EnumType
 * @subpackage Enumerations
 */
class EnumPathInfoReturnType
{
    /**
     * Constant for value 'SUMMARY_INFO'
     * @return string 'SUMMARY_INFO'
     */
    const VALUE_SUMMARY_INFO = 'SUMMARY_INFO';
    /**
     * Constant for value 'DETAIL_INFO'
     * @return string 'DETAIL_INFO'
     */
    const VALUE_DETAIL_INFO = 'DETAIL_INFO';
    /**
     * Constant for value 'BOTH'
     * @return string 'BOTH'
     */
    const VALUE_BOTH = 'BOTH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUMMARY_INFO
     * @uses self::VALUE_DETAIL_INFO
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUMMARY_INFO,
            self::VALUE_DETAIL_INFO,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
