<?php

namespace EnumType;

/**
 * This class stands for enumIdentifierType EnumType
 * @subpackage Enumerations
 */
class EnumIdentifierType
{
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'TRANSICS_ID'
     * @return string 'TRANSICS_ID'
     */
    const VALUE_TRANSICS_ID = 'TRANSICS_ID';
    /**
     * Constant for value 'CODE'
     * @return string 'CODE'
     */
    const VALUE_CODE = 'CODE';
    /**
     * Constant for value 'TACHO_CARD_ID'
     * @return string 'TACHO_CARD_ID'
     */
    const VALUE_TACHO_CARD_ID = 'TACHO_CARD_ID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID
     * @uses self::VALUE_TRANSICS_ID
     * @uses self::VALUE_CODE
     * @uses self::VALUE_TACHO_CARD_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID,
            self::VALUE_TRANSICS_ID,
            self::VALUE_CODE,
            self::VALUE_TACHO_CARD_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
