<?php

namespace EnumType;

/**
 * This class stands for enumIdentifierSiteType EnumType
 * @subpackage Enumerations
 */
class EnumIdentifierSiteType
{
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'TRANSICS_ID'
     * @return string 'TRANSICS_ID'
     */
    const VALUE_TRANSICS_ID = 'TRANSICS_ID';
    /**
     * Constant for value 'CODE'
     * @return string 'CODE'
     */
    const VALUE_CODE = 'CODE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID
     * @uses self::VALUE_TRANSICS_ID
     * @uses self::VALUE_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID,
            self::VALUE_TRANSICS_ID,
            self::VALUE_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
