<?php

namespace EnumType;

/**
 * This class stands for enumFileTransferStatus EnumType
 * @subpackage Enumerations
 */
class EnumFileTransferStatus
{
    /**
     * Constant for value 'NOT_SEND'
     * @return string 'NOT_SEND'
     */
    const VALUE_NOT_SEND = 'NOT_SEND';
    /**
     * Constant for value 'BEING_SEND'
     * @return string 'BEING_SEND'
     */
    const VALUE_BEING_SEND = 'BEING_SEND';
    /**
     * Constant for value 'ON_FTP_SERVER'
     * @return string 'ON_FTP_SERVER'
     */
    const VALUE_ON_FTP_SERVER = 'ON_FTP_SERVER';
    /**
     * Constant for value 'RECEIVED_BY_OBC'
     * @return string 'RECEIVED_BY_OBC'
     */
    const VALUE_RECEIVED_BY_OBC = 'RECEIVED_BY_OBC';
    /**
     * Constant for value 'ERROR_FILEDATA'
     * @return string 'ERROR_FILEDATA'
     */
    const VALUE_ERROR_FILEDATA = 'ERROR_FILEDATA';
    /**
     * Constant for value 'ERROR_WRITE_FILE'
     * @return string 'ERROR_WRITE_FILE'
     */
    const VALUE_ERROR_WRITE_FILE = 'ERROR_WRITE_FILE';
    /**
     * Constant for value 'ERROR_GENERAL'
     * @return string 'ERROR_GENERAL'
     */
    const VALUE_ERROR_GENERAL = 'ERROR_GENERAL';
    /**
     * Constant for value 'FROM_IMWS'
     * @return string 'FROM_IMWS'
     */
    const VALUE_FROM_IMWS = 'FROM_IMWS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SEND
     * @uses self::VALUE_BEING_SEND
     * @uses self::VALUE_ON_FTP_SERVER
     * @uses self::VALUE_RECEIVED_BY_OBC
     * @uses self::VALUE_ERROR_FILEDATA
     * @uses self::VALUE_ERROR_WRITE_FILE
     * @uses self::VALUE_ERROR_GENERAL
     * @uses self::VALUE_FROM_IMWS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SEND,
            self::VALUE_BEING_SEND,
            self::VALUE_ON_FTP_SERVER,
            self::VALUE_RECEIVED_BY_OBC,
            self::VALUE_ERROR_FILEDATA,
            self::VALUE_ERROR_WRITE_FILE,
            self::VALUE_ERROR_GENERAL,
            self::VALUE_FROM_IMWS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
