<?php

namespace EnumType;

/**
 * This class stands for enumEcoScope EnumType
 * @subpackage Enumerations
 */
class EnumEcoScope
{
    /**
     * Constant for value 'TRIP'
     * @return string 'TRIP'
     */
    const VALUE_TRIP = 'TRIP';
    /**
     * Constant for value 'CONTINUOUS'
     * @return string 'CONTINUOUS'
     */
    const VALUE_CONTINUOUS = 'CONTINUOUS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRIP
     * @uses self::VALUE_CONTINUOUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRIP,
            self::VALUE_CONTINUOUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
