<?php

namespace EnumType;

/**
 * This class stands for enumETAStatus EnumType
 * @subpackage Enumerations
 */
class EnumETAStatus
{
    /**
     * Constant for value 'ONTARGET'
     * @return string 'ONTARGET'
     */
    const VALUE_ONTARGET = 'ONTARGET';
    /**
     * Constant for value 'ARRIVED'
     * @return string 'ARRIVED'
     */
    const VALUE_ARRIVED = 'ARRIVED';
    /**
     * Constant for value 'ABORTED'
     * @return string 'ABORTED'
     */
    const VALUE_ABORTED = 'ABORTED';
    /**
     * Constant for value 'CHANGED_TO_EARLY'
     * @return string 'CHANGED_TO_EARLY'
     */
    const VALUE_CHANGED_TO_EARLY = 'CHANGED_TO_EARLY';
    /**
     * Constant for value 'CHANGED_TO_LATER'
     * @return string 'CHANGED_TO_LATER'
     */
    const VALUE_CHANGED_TO_LATER = 'CHANGED_TO_LATER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONTARGET
     * @uses self::VALUE_ARRIVED
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_CHANGED_TO_EARLY
     * @uses self::VALUE_CHANGED_TO_LATER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONTARGET,
            self::VALUE_ARRIVED,
            self::VALUE_ABORTED,
            self::VALUE_CHANGED_TO_EARLY,
            self::VALUE_CHANGED_TO_LATER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
