<?php

namespace EnumType;

/**
 * This class stands for enumDataDirection EnumType
 * @subpackage Enumerations
 */
class EnumDataDirection
{
    /**
     * Constant for value 'INCOMING'
     * @return string 'INCOMING'
     */
    const VALUE_INCOMING = 'INCOMING';
    /**
     * Constant for value 'OUTGOING'
     * @return string 'OUTGOING'
     */
    const VALUE_OUTGOING = 'OUTGOING';
    /**
     * Constant for value 'BOTH'
     * @return string 'BOTH'
     */
    const VALUE_BOTH = 'BOTH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INCOMING
     * @uses self::VALUE_OUTGOING
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCOMING,
            self::VALUE_OUTGOING,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
