<?php

namespace EnumType;

/**
 * This class stands for enumCompanyIdentifierType EnumType
 * @subpackage Enumerations
 */
class EnumCompanyIdentifierType
{
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'CODE'
     * @return string 'CODE'
     */
    const VALUE_CODE = 'CODE';
    /**
     * Constant for value 'NAME'
     * @return string 'NAME'
     */
    const VALUE_NAME = 'NAME';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID
     * @uses self::VALUE_CODE
     * @uses self::VALUE_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID,
            self::VALUE_CODE,
            self::VALUE_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
