<?php

namespace EnumType;

/**
 * This class stands for enumCheckOffType EnumType
 * @subpackage Enumerations
 */
class EnumCheckOffType
{
    /**
     * Constant for value 'Manual'
     * @return string 'Manual'
     */
    const VALUE_MANUAL = 'Manual';
    /**
     * Constant for value 'Scanned'
     * @return string 'Scanned'
     */
    const VALUE_SCANNED = 'Scanned';
    /**
     * Constant for value 'NotCheckedOff'
     * @return string 'NotCheckedOff'
     */
    const VALUE_NOT_CHECKED_OFF = 'NotCheckedOff';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MANUAL
     * @uses self::VALUE_SCANNED
     * @uses self::VALUE_NOT_CHECKED_OFF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANUAL,
            self::VALUE_SCANNED,
            self::VALUE_NOT_CHECKED_OFF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
