<?php

namespace EnumType;

/**
 * This class stands for enumAlarmMessageType EnumType
 * @subpackage Enumerations
 */
class EnumAlarmMessageType
{
    /**
     * Constant for value 'STATUS_TAKES_TOLONG'
     * @return string 'STATUS_TAKES_TOLONG'
     */
    const VALUE_STATUS_TAKES_TOLONG = 'STATUS_TAKES_TOLONG';
    /**
     * Constant for value 'TOLONG_AT_CUSTOMER'
     * @return string 'TOLONG_AT_CUSTOMER'
     */
    const VALUE_TOLONG_AT_CUSTOMER = 'TOLONG_AT_CUSTOMER';
    /**
     * Constant for value 'ON_ROBBER_STABLE'
     * @return string 'ON_ROBBER_STABLE'
     */
    const VALUE_ON_ROBBER_STABLE = 'ON_ROBBER_STABLE';
    /**
     * Constant for value 'PTO_MESSAGES'
     * @return string 'PTO_MESSAGES'
     */
    const VALUE_PTO_MESSAGES = 'PTO_MESSAGES';
    /**
     * Constant for value 'SOS_ALARM'
     * @return string 'SOS_ALARM'
     */
    const VALUE_SOS_ALARM = 'SOS_ALARM';
    /**
     * Constant for value 'SOLOTRANS_STATUS'
     * @return string 'SOLOTRANS_STATUS'
     */
    const VALUE_SOLOTRANS_STATUS = 'SOLOTRANS_STATUS';
    /**
     * Constant for value 'AFTER_START_WITHOUT_CARD'
     * @return string 'AFTER_START_WITHOUT_CARD'
     */
    const VALUE_AFTER_START_WITHOUT_CARD = 'AFTER_START_WITHOUT_CARD';
    /**
     * Constant for value 'CARD_90PERCENT_FULL'
     * @return string 'CARD_90PERCENT_FULL'
     */
    const VALUE_CARD_90_PERCENT_FULL = 'CARD_90PERCENT_FULL';
    /**
     * Constant for value 'GEOFENCING'
     * @return string 'GEOFENCING'
     */
    const VALUE_GEOFENCING = 'GEOFENCING';
    /**
     * Constant for value 'DRIVINGTIMES'
     * @return string 'DRIVINGTIMES'
     */
    const VALUE_DRIVINGTIMES = 'DRIVINGTIMES';
    /**
     * Constant for value 'CLEANREBOOT'
     * @return string 'CLEANREBOOT'
     */
    const VALUE_CLEANREBOOT = 'CLEANREBOOT';
    /**
     * Constant for value 'CHANGENAME'
     * @return string 'CHANGENAME'
     */
    const VALUE_CHANGENAME = 'CHANGENAME';
    /**
     * Constant for value 'THERMOKING'
     * @return string 'THERMOKING'
     */
    const VALUE_THERMOKING = 'THERMOKING';
    /**
     * Constant for value 'IMAGEUPDATE'
     * @return string 'IMAGEUPDATE'
     */
    const VALUE_IMAGEUPDATE = 'IMAGEUPDATE';
    /**
     * Constant for value 'VERSIONUPDATE'
     * @return string 'VERSIONUPDATE'
     */
    const VALUE_VERSIONUPDATE = 'VERSIONUPDATE';
    /**
     * Constant for value 'CARDPARAMETERS'
     * @return string 'CARDPARAMETERS'
     */
    const VALUE_CARDPARAMETERS = 'CARDPARAMETERS';
    /**
     * Constant for value 'BLACKLIST'
     * @return string 'BLACKLIST'
     */
    const VALUE_BLACKLIST = 'BLACKLIST';
    /**
     * Constant for value 'DATETIMECHANGED'
     * @return string 'DATETIMECHANGED'
     */
    const VALUE_DATETIMECHANGED = 'DATETIMECHANGED';
    /**
     * Constant for value 'DEAD_MAN_BUTTON'
     * @return string 'DEAD_MAN_BUTTON'
     */
    const VALUE_DEAD_MAN_BUTTON = 'DEAD_MAN_BUTTON';
    /**
     * Constant for value 'QDA'
     * @return string 'QDA'
     */
    const VALUE_QDA = 'QDA';
    /**
     * Constant for value 'FUEL_LEVEL'
     * @return string 'FUEL_LEVEL'
     */
    const VALUE_FUEL_LEVEL = 'FUEL_LEVEL';
    /**
     * Constant for value 'SUCCESSIVE_MSG'
     * @return string 'SUCCESSIVE_MSG'
     */
    const VALUE_SUCCESSIVE_MSG = 'SUCCESSIVE_MSG';
    /**
     * Constant for value 'WRONG_OBC_TIME'
     * @return string 'WRONG_OBC_TIME'
     */
    const VALUE_WRONG_OBC_TIME = 'WRONG_OBC_TIME';
    /**
     * Constant for value 'ENG_PROTECTION'
     * @return string 'ENG_PROTECTION'
     */
    const VALUE_ENG_PROTECTION = 'ENG_PROTECTION';
    /**
     * Constant for value 'EVL_POSITION'
     * @return string 'EVL_POSITION'
     */
    const VALUE_EVL_POSITION = 'EVL_POSITION';
    /**
     * Constant for value 'READONLY_FILE_FTP'
     * @return string 'READONLY_FILE_FTP'
     */
    const VALUE_READONLY_FILE_FTP = 'READONLY_FILE_FTP';
    /**
     * Constant for value 'DEADLINE_READCONF_EXC'
     * @return string 'DEADLINE_READCONF_EXC'
     */
    const VALUE_DEADLINE_READCONF_EXC = 'DEADLINE_READCONF_EXC';
    /**
     * Constant for value 'TOO_MUCH_GPRS_TRAFFIC'
     * @return string 'TOO_MUCH_GPRS_TRAFFIC'
     */
    const VALUE_TOO_MUCH_GPRS_TRAFFIC = 'TOO_MUCH_GPRS_TRAFFIC';
    /**
     * Constant for value 'ON_TACHO_PULSE'
     * @return string 'ON_TACHO_PULSE'
     */
    const VALUE_ON_TACHO_PULSE = 'ON_TACHO_PULSE';
    /**
     * Constant for value 'INFOMOB_ALARM'
     * @return string 'INFOMOB_ALARM'
     */
    const VALUE_INFOMOB_ALARM = 'INFOMOB_ALARM';
    /**
     * Constant for value 'ON_SERVICE_TIMES'
     * @return string 'ON_SERVICE_TIMES'
     */
    const VALUE_ON_SERVICE_TIMES = 'ON_SERVICE_TIMES';
    /**
     * Constant for value 'CORRIDOR'
     * @return string 'CORRIDOR'
     */
    const VALUE_CORRIDOR = 'CORRIDOR';
    /**
     * Constant for value 'NEXT_STOP'
     * @return string 'NEXT_STOP'
     */
    const VALUE_NEXT_STOP = 'NEXT_STOP';
    /**
     * Constant for value 'VIAROUTE'
     * @return string 'VIAROUTE'
     */
    const VALUE_VIAROUTE = 'VIAROUTE';
    /**
     * Constant for value 'TCS_NO_VEH_FOR_ADDRESS'
     * @return string 'TCS_NO_VEH_FOR_ADDRESS'
     */
    const VALUE_TCS_NO_VEH_FOR_ADDRESS = 'TCS_NO_VEH_FOR_ADDRESS';
    /**
     * Constant for value 'TCS_NO_DRIVER_FOR_LAURA'
     * @return string 'TCS_NO_DRIVER_FOR_LAURA'
     */
    const VALUE_TCS_NO_DRIVER_FOR_LAURA = 'TCS_NO_DRIVER_FOR_LAURA';
    /**
     * Constant for value 'TCS_NO_DRIVER_FOR_QUATTRO'
     * @return string 'TCS_NO_DRIVER_FOR_QUATTRO'
     */
    const VALUE_TCS_NO_DRIVER_FOR_QUATTRO = 'TCS_NO_DRIVER_FOR_QUATTRO';
    /**
     * Constant for value 'TCS_TCG_DOWN'
     * @return string 'TCS_TCG_DOWN'
     */
    const VALUE_TCS_TCG_DOWN = 'TCS_TCG_DOWN';
    /**
     * Constant for value 'TCS_CONNECTION_DOWN'
     * @return string 'TCS_CONNECTION_DOWN'
     */
    const VALUE_TCS_CONNECTION_DOWN = 'TCS_CONNECTION_DOWN';
    /**
     * Constant for value 'TCS_LIC_NOT_VALID'
     * @return string 'TCS_LIC_NOT_VALID'
     */
    const VALUE_TCS_LIC_NOT_VALID = 'TCS_LIC_NOT_VALID';
    /**
     * Constant for value 'TCS_OTHER'
     * @return string 'TCS_OTHER'
     */
    const VALUE_TCS_OTHER = 'TCS_OTHER';
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Constant for value 'VARIABLE'
     * @return string 'VARIABLE'
     */
    const VALUE_VARIABLE = 'VARIABLE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STATUS_TAKES_TOLONG
     * @uses self::VALUE_TOLONG_AT_CUSTOMER
     * @uses self::VALUE_ON_ROBBER_STABLE
     * @uses self::VALUE_PTO_MESSAGES
     * @uses self::VALUE_SOS_ALARM
     * @uses self::VALUE_SOLOTRANS_STATUS
     * @uses self::VALUE_AFTER_START_WITHOUT_CARD
     * @uses self::VALUE_CARD_90_PERCENT_FULL
     * @uses self::VALUE_GEOFENCING
     * @uses self::VALUE_DRIVINGTIMES
     * @uses self::VALUE_CLEANREBOOT
     * @uses self::VALUE_CHANGENAME
     * @uses self::VALUE_THERMOKING
     * @uses self::VALUE_IMAGEUPDATE
     * @uses self::VALUE_VERSIONUPDATE
     * @uses self::VALUE_CARDPARAMETERS
     * @uses self::VALUE_BLACKLIST
     * @uses self::VALUE_DATETIMECHANGED
     * @uses self::VALUE_DEAD_MAN_BUTTON
     * @uses self::VALUE_QDA
     * @uses self::VALUE_FUEL_LEVEL
     * @uses self::VALUE_SUCCESSIVE_MSG
     * @uses self::VALUE_WRONG_OBC_TIME
     * @uses self::VALUE_ENG_PROTECTION
     * @uses self::VALUE_EVL_POSITION
     * @uses self::VALUE_READONLY_FILE_FTP
     * @uses self::VALUE_DEADLINE_READCONF_EXC
     * @uses self::VALUE_TOO_MUCH_GPRS_TRAFFIC
     * @uses self::VALUE_ON_TACHO_PULSE
     * @uses self::VALUE_INFOMOB_ALARM
     * @uses self::VALUE_ON_SERVICE_TIMES
     * @uses self::VALUE_CORRIDOR
     * @uses self::VALUE_NEXT_STOP
     * @uses self::VALUE_VIAROUTE
     * @uses self::VALUE_TCS_NO_VEH_FOR_ADDRESS
     * @uses self::VALUE_TCS_NO_DRIVER_FOR_LAURA
     * @uses self::VALUE_TCS_NO_DRIVER_FOR_QUATTRO
     * @uses self::VALUE_TCS_TCG_DOWN
     * @uses self::VALUE_TCS_CONNECTION_DOWN
     * @uses self::VALUE_TCS_LIC_NOT_VALID
     * @uses self::VALUE_TCS_OTHER
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VARIABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STATUS_TAKES_TOLONG,
            self::VALUE_TOLONG_AT_CUSTOMER,
            self::VALUE_ON_ROBBER_STABLE,
            self::VALUE_PTO_MESSAGES,
            self::VALUE_SOS_ALARM,
            self::VALUE_SOLOTRANS_STATUS,
            self::VALUE_AFTER_START_WITHOUT_CARD,
            self::VALUE_CARD_90_PERCENT_FULL,
            self::VALUE_GEOFENCING,
            self::VALUE_DRIVINGTIMES,
            self::VALUE_CLEANREBOOT,
            self::VALUE_CHANGENAME,
            self::VALUE_THERMOKING,
            self::VALUE_IMAGEUPDATE,
            self::VALUE_VERSIONUPDATE,
            self::VALUE_CARDPARAMETERS,
            self::VALUE_BLACKLIST,
            self::VALUE_DATETIMECHANGED,
            self::VALUE_DEAD_MAN_BUTTON,
            self::VALUE_QDA,
            self::VALUE_FUEL_LEVEL,
            self::VALUE_SUCCESSIVE_MSG,
            self::VALUE_WRONG_OBC_TIME,
            self::VALUE_ENG_PROTECTION,
            self::VALUE_EVL_POSITION,
            self::VALUE_READONLY_FILE_FTP,
            self::VALUE_DEADLINE_READCONF_EXC,
            self::VALUE_TOO_MUCH_GPRS_TRAFFIC,
            self::VALUE_ON_TACHO_PULSE,
            self::VALUE_INFOMOB_ALARM,
            self::VALUE_ON_SERVICE_TIMES,
            self::VALUE_CORRIDOR,
            self::VALUE_NEXT_STOP,
            self::VALUE_VIAROUTE,
            self::VALUE_TCS_NO_VEH_FOR_ADDRESS,
            self::VALUE_TCS_NO_DRIVER_FOR_LAURA,
            self::VALUE_TCS_NO_DRIVER_FOR_QUATTRO,
            self::VALUE_TCS_TCG_DOWN,
            self::VALUE_TCS_CONNECTION_DOWN,
            self::VALUE_TCS_LIC_NOT_VALID,
            self::VALUE_TCS_OTHER,
            self::VALUE_UNKNOWN,
            self::VALUE_VARIABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
