<?php

namespace EnumType;

/**
 * This class stands for enumActivityType EnumType
 * @subpackage Enumerations
 */
class EnumActivityType
{
    /**
     * Constant for value 'ACTIVITY'
     * @return string 'ACTIVITY'
     */
    const VALUE_ACTIVITY = 'ACTIVITY';
    /**
     * Constant for value 'REGISTRATION'
     * @return string 'REGISTRATION'
     */
    const VALUE_REGISTRATION = 'REGISTRATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVITY
     * @uses self::VALUE_REGISTRATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVITY,
            self::VALUE_REGISTRATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
