<?php

namespace EnumType;

/**
 * This class stands for enumActivityStatus EnumType
 * @subpackage Enumerations
 */
class EnumActivityStatus
{
    /**
     * Constant for value 'BEGIN'
     * @return string 'BEGIN'
     */
    const VALUE_BEGIN = 'BEGIN';
    /**
     * Constant for value 'END'
     * @return string 'END'
     */
    const VALUE_END = 'END';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEGIN
     * @uses self::VALUE_END
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEGIN,
            self::VALUE_END,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
