<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWarning ArrayType
 * @subpackage Arrays
 */
class ArrayOfWarning extends AbstractStructArrayBase
{
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Warning[]
     */
    public $Warning;
    /**
     * Constructor method for ArrayOfWarning
     * @uses ArrayOfWarning::setWarning()
     * @param \StructType\Warning[] $warning
     */
    public function __construct(array $warning = array())
    {
        $this
            ->setWarning($warning);
    }
    /**
     * Get Warning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Warning[]|null
     */
    public function getWarning()
    {
        return isset($this->Warning) ? $this->Warning : null;
    }
    /**
     * Set Warning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Warning[] $warning
     * @return \ArrayType\ArrayOfWarning
     */
    public function setWarning(array $warning = array())
    {
        foreach ($warning as $arrayOfWarningWarningItem) {
            // validation for constraint: itemType
            if (!$arrayOfWarningWarningItem instanceof \StructType\Warning) {
                throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \StructType\Warning, "%s" given', is_object($arrayOfWarningWarningItem) ? get_class($arrayOfWarningWarningItem) : gettype($arrayOfWarningWarningItem)), __LINE__);
            }
        }
        if (is_null($warning) || (is_array($warning) && empty($warning))) {
            unset($this->Warning);
        } else {
            $this->Warning = $warning;
        }
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\Warning $item
     * @return \ArrayType\ArrayOfWarning
     */
    public function addToWarning(\StructType\Warning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Warning) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \StructType\Warning, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Warning|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Warning|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Warning|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Warning|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Warning|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Warning
     */
    public function getAttributeName()
    {
        return 'Warning';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWarning
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
