<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleTag ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleTag extends AbstractStructArrayBase
{
    /**
     * The VehicleTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleTag[]
     */
    public $VehicleTag;
    /**
     * Constructor method for ArrayOfVehicleTag
     * @uses ArrayOfVehicleTag::setVehicleTag()
     * @param \StructType\VehicleTag[] $vehicleTag
     */
    public function __construct(array $vehicleTag = array())
    {
        $this
            ->setVehicleTag($vehicleTag);
    }
    /**
     * Get VehicleTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleTag[]|null
     */
    public function getVehicleTag()
    {
        return isset($this->VehicleTag) ? $this->VehicleTag : null;
    }
    /**
     * Set VehicleTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleTag[] $vehicleTag
     * @return \ArrayType\ArrayOfVehicleTag
     */
    public function setVehicleTag(array $vehicleTag = array())
    {
        foreach ($vehicleTag as $arrayOfVehicleTagVehicleTagItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleTagVehicleTagItem instanceof \StructType\VehicleTag) {
                throw new \InvalidArgumentException(sprintf('The VehicleTag property can only contain items of \StructType\VehicleTag, "%s" given', is_object($arrayOfVehicleTagVehicleTagItem) ? get_class($arrayOfVehicleTagVehicleTagItem) : gettype($arrayOfVehicleTagVehicleTagItem)), __LINE__);
            }
        }
        if (is_null($vehicleTag) || (is_array($vehicleTag) && empty($vehicleTag))) {
            unset($this->VehicleTag);
        } else {
            $this->VehicleTag = $vehicleTag;
        }
        return $this;
    }
    /**
     * Add item to VehicleTag value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleTag $item
     * @return \ArrayType\ArrayOfVehicleTag
     */
    public function addToVehicleTag(\StructType\VehicleTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleTag) {
            throw new \InvalidArgumentException(sprintf('The VehicleTag property can only contain items of \StructType\VehicleTag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleTag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleTag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleTag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleTag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleTag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleTag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleTag
     */
    public function getAttributeName()
    {
        return 'VehicleTag';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleTag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
