<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleResult extends AbstractStructArrayBase
{
    /**
     * The VehicleResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleResult[]
     */
    public $VehicleResult;
    /**
     * Constructor method for ArrayOfVehicleResult
     * @uses ArrayOfVehicleResult::setVehicleResult()
     * @param \StructType\VehicleResult[] $vehicleResult
     */
    public function __construct(array $vehicleResult = array())
    {
        $this
            ->setVehicleResult($vehicleResult);
    }
    /**
     * Get VehicleResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleResult[]|null
     */
    public function getVehicleResult()
    {
        return isset($this->VehicleResult) ? $this->VehicleResult : null;
    }
    /**
     * Set VehicleResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleResult[] $vehicleResult
     * @return \ArrayType\ArrayOfVehicleResult
     */
    public function setVehicleResult(array $vehicleResult = array())
    {
        foreach ($vehicleResult as $arrayOfVehicleResultVehicleResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleResultVehicleResultItem instanceof \StructType\VehicleResult) {
                throw new \InvalidArgumentException(sprintf('The VehicleResult property can only contain items of \StructType\VehicleResult, "%s" given', is_object($arrayOfVehicleResultVehicleResultItem) ? get_class($arrayOfVehicleResultVehicleResultItem) : gettype($arrayOfVehicleResultVehicleResultItem)), __LINE__);
            }
        }
        if (is_null($vehicleResult) || (is_array($vehicleResult) && empty($vehicleResult))) {
            unset($this->VehicleResult);
        } else {
            $this->VehicleResult = $vehicleResult;
        }
        return $this;
    }
    /**
     * Add item to VehicleResult value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleResult $item
     * @return \ArrayType\ArrayOfVehicleResult
     */
    public function addToVehicleResult(\StructType\VehicleResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleResult) {
            throw new \InvalidArgumentException(sprintf('The VehicleResult property can only contain items of \StructType\VehicleResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleResult
     */
    public function getAttributeName()
    {
        return 'VehicleResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
