<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrailerGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrailerGroupItem extends AbstractStructArrayBase
{
    /**
     * The TrailerGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrailerGroupItem[]
     */
    public $TrailerGroupItem;
    /**
     * Constructor method for ArrayOfTrailerGroupItem
     * @uses ArrayOfTrailerGroupItem::setTrailerGroupItem()
     * @param \StructType\TrailerGroupItem[] $trailerGroupItem
     */
    public function __construct(array $trailerGroupItem = array())
    {
        $this
            ->setTrailerGroupItem($trailerGroupItem);
    }
    /**
     * Get TrailerGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrailerGroupItem[]|null
     */
    public function getTrailerGroupItem()
    {
        return isset($this->TrailerGroupItem) ? $this->TrailerGroupItem : null;
    }
    /**
     * Set TrailerGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerGroupItem[] $trailerGroupItem
     * @return \ArrayType\ArrayOfTrailerGroupItem
     */
    public function setTrailerGroupItem(array $trailerGroupItem = array())
    {
        foreach ($trailerGroupItem as $arrayOfTrailerGroupItemTrailerGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrailerGroupItemTrailerGroupItemItem instanceof \StructType\TrailerGroupItem) {
                throw new \InvalidArgumentException(sprintf('The TrailerGroupItem property can only contain items of \StructType\TrailerGroupItem, "%s" given', is_object($arrayOfTrailerGroupItemTrailerGroupItemItem) ? get_class($arrayOfTrailerGroupItemTrailerGroupItemItem) : gettype($arrayOfTrailerGroupItemTrailerGroupItemItem)), __LINE__);
            }
        }
        if (is_null($trailerGroupItem) || (is_array($trailerGroupItem) && empty($trailerGroupItem))) {
            unset($this->TrailerGroupItem);
        } else {
            $this->TrailerGroupItem = $trailerGroupItem;
        }
        return $this;
    }
    /**
     * Add item to TrailerGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerGroupItem $item
     * @return \ArrayType\ArrayOfTrailerGroupItem
     */
    public function addToTrailerGroupItem(\StructType\TrailerGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailerGroupItem) {
            throw new \InvalidArgumentException(sprintf('The TrailerGroupItem property can only contain items of \StructType\TrailerGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrailerGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrailerGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrailerGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrailerGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrailerGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrailerGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrailerGroupItem
     */
    public function getAttributeName()
    {
        return 'TrailerGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTrailerGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
