<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemperatureResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTemperatureResult extends AbstractStructArrayBase
{
    /**
     * The TemperatureResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TemperatureResult[]
     */
    public $TemperatureResult;
    /**
     * Constructor method for ArrayOfTemperatureResult
     * @uses ArrayOfTemperatureResult::setTemperatureResult()
     * @param \StructType\TemperatureResult[] $temperatureResult
     */
    public function __construct(array $temperatureResult = array())
    {
        $this
            ->setTemperatureResult($temperatureResult);
    }
    /**
     * Get TemperatureResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TemperatureResult[]|null
     */
    public function getTemperatureResult()
    {
        return isset($this->TemperatureResult) ? $this->TemperatureResult : null;
    }
    /**
     * Set TemperatureResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureResult[] $temperatureResult
     * @return \ArrayType\ArrayOfTemperatureResult
     */
    public function setTemperatureResult(array $temperatureResult = array())
    {
        foreach ($temperatureResult as $arrayOfTemperatureResultTemperatureResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemperatureResultTemperatureResultItem instanceof \StructType\TemperatureResult) {
                throw new \InvalidArgumentException(sprintf('The TemperatureResult property can only contain items of \StructType\TemperatureResult, "%s" given', is_object($arrayOfTemperatureResultTemperatureResultItem) ? get_class($arrayOfTemperatureResultTemperatureResultItem) : gettype($arrayOfTemperatureResultTemperatureResultItem)), __LINE__);
            }
        }
        if (is_null($temperatureResult) || (is_array($temperatureResult) && empty($temperatureResult))) {
            unset($this->TemperatureResult);
        } else {
            $this->TemperatureResult = $temperatureResult;
        }
        return $this;
    }
    /**
     * Add item to TemperatureResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureResult $item
     * @return \ArrayType\ArrayOfTemperatureResult
     */
    public function addToTemperatureResult(\StructType\TemperatureResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TemperatureResult) {
            throw new \InvalidArgumentException(sprintf('The TemperatureResult property can only contain items of \StructType\TemperatureResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TemperatureResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TemperatureResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TemperatureResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TemperatureResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TemperatureResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TemperatureResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TemperatureResult
     */
    public function getAttributeName()
    {
        return 'TemperatureResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTemperatureResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
