<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTelemetricDataItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTelemetricDataItem extends AbstractStructArrayBase
{
    /**
     * The TelemetricDataItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TelemetricDataItem[]
     */
    public $TelemetricDataItem;
    /**
     * Constructor method for ArrayOfTelemetricDataItem
     * @uses ArrayOfTelemetricDataItem::setTelemetricDataItem()
     * @param \StructType\TelemetricDataItem[] $telemetricDataItem
     */
    public function __construct(array $telemetricDataItem = array())
    {
        $this
            ->setTelemetricDataItem($telemetricDataItem);
    }
    /**
     * Get TelemetricDataItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TelemetricDataItem[]|null
     */
    public function getTelemetricDataItem()
    {
        return isset($this->TelemetricDataItem) ? $this->TelemetricDataItem : null;
    }
    /**
     * Set TelemetricDataItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TelemetricDataItem[] $telemetricDataItem
     * @return \ArrayType\ArrayOfTelemetricDataItem
     */
    public function setTelemetricDataItem(array $telemetricDataItem = array())
    {
        foreach ($telemetricDataItem as $arrayOfTelemetricDataItemTelemetricDataItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTelemetricDataItemTelemetricDataItemItem instanceof \StructType\TelemetricDataItem) {
                throw new \InvalidArgumentException(sprintf('The TelemetricDataItem property can only contain items of \StructType\TelemetricDataItem, "%s" given', is_object($arrayOfTelemetricDataItemTelemetricDataItemItem) ? get_class($arrayOfTelemetricDataItemTelemetricDataItemItem) : gettype($arrayOfTelemetricDataItemTelemetricDataItemItem)), __LINE__);
            }
        }
        if (is_null($telemetricDataItem) || (is_array($telemetricDataItem) && empty($telemetricDataItem))) {
            unset($this->TelemetricDataItem);
        } else {
            $this->TelemetricDataItem = $telemetricDataItem;
        }
        return $this;
    }
    /**
     * Add item to TelemetricDataItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TelemetricDataItem $item
     * @return \ArrayType\ArrayOfTelemetricDataItem
     */
    public function addToTelemetricDataItem(\StructType\TelemetricDataItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelemetricDataItem) {
            throw new \InvalidArgumentException(sprintf('The TelemetricDataItem property can only contain items of \StructType\TelemetricDataItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TelemetricDataItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TelemetricDataItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TelemetricDataItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TelemetricDataItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TelemetricDataItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TelemetricDataItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TelemetricDataItem
     */
    public function getAttributeName()
    {
        return 'TelemetricDataItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTelemetricDataItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
