<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTachoReadoutItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTachoReadoutItem extends AbstractStructArrayBase
{
    /**
     * The TachoReadoutItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TachoReadoutItem[]
     */
    public $TachoReadoutItem;
    /**
     * Constructor method for ArrayOfTachoReadoutItem
     * @uses ArrayOfTachoReadoutItem::setTachoReadoutItem()
     * @param \StructType\TachoReadoutItem[] $tachoReadoutItem
     */
    public function __construct(array $tachoReadoutItem = array())
    {
        $this
            ->setTachoReadoutItem($tachoReadoutItem);
    }
    /**
     * Get TachoReadoutItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TachoReadoutItem[]|null
     */
    public function getTachoReadoutItem()
    {
        return isset($this->TachoReadoutItem) ? $this->TachoReadoutItem : null;
    }
    /**
     * Set TachoReadoutItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TachoReadoutItem[] $tachoReadoutItem
     * @return \ArrayType\ArrayOfTachoReadoutItem
     */
    public function setTachoReadoutItem(array $tachoReadoutItem = array())
    {
        foreach ($tachoReadoutItem as $arrayOfTachoReadoutItemTachoReadoutItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTachoReadoutItemTachoReadoutItemItem instanceof \StructType\TachoReadoutItem) {
                throw new \InvalidArgumentException(sprintf('The TachoReadoutItem property can only contain items of \StructType\TachoReadoutItem, "%s" given', is_object($arrayOfTachoReadoutItemTachoReadoutItemItem) ? get_class($arrayOfTachoReadoutItemTachoReadoutItemItem) : gettype($arrayOfTachoReadoutItemTachoReadoutItemItem)), __LINE__);
            }
        }
        if (is_null($tachoReadoutItem) || (is_array($tachoReadoutItem) && empty($tachoReadoutItem))) {
            unset($this->TachoReadoutItem);
        } else {
            $this->TachoReadoutItem = $tachoReadoutItem;
        }
        return $this;
    }
    /**
     * Add item to TachoReadoutItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TachoReadoutItem $item
     * @return \ArrayType\ArrayOfTachoReadoutItem
     */
    public function addToTachoReadoutItem(\StructType\TachoReadoutItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TachoReadoutItem) {
            throw new \InvalidArgumentException(sprintf('The TachoReadoutItem property can only contain items of \StructType\TachoReadoutItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TachoReadoutItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TachoReadoutItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TachoReadoutItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TachoReadoutItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TachoReadoutItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TachoReadoutItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TachoReadoutItem
     */
    public function getAttributeName()
    {
        return 'TachoReadoutItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTachoReadoutItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
