<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubGroup extends AbstractStructArrayBase
{
    /**
     * The SubGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubGroup[]
     */
    public $SubGroup;
    /**
     * Constructor method for ArrayOfSubGroup
     * @uses ArrayOfSubGroup::setSubGroup()
     * @param \StructType\SubGroup[] $subGroup
     */
    public function __construct(array $subGroup = array())
    {
        $this
            ->setSubGroup($subGroup);
    }
    /**
     * Get SubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubGroup[]|null
     */
    public function getSubGroup()
    {
        return isset($this->SubGroup) ? $this->SubGroup : null;
    }
    /**
     * Set SubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup[] $subGroup
     * @return \ArrayType\ArrayOfSubGroup
     */
    public function setSubGroup(array $subGroup = array())
    {
        foreach ($subGroup as $arrayOfSubGroupSubGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubGroupSubGroupItem instanceof \StructType\SubGroup) {
                throw new \InvalidArgumentException(sprintf('The SubGroup property can only contain items of \StructType\SubGroup, "%s" given', is_object($arrayOfSubGroupSubGroupItem) ? get_class($arrayOfSubGroupSubGroupItem) : gettype($arrayOfSubGroupSubGroupItem)), __LINE__);
            }
        }
        if (is_null($subGroup) || (is_array($subGroup) && empty($subGroup))) {
            unset($this->SubGroup);
        } else {
            $this->SubGroup = $subGroup;
        }
        return $this;
    }
    /**
     * Add item to SubGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup $item
     * @return \ArrayType\ArrayOfSubGroup
     */
    public function addToSubGroup(\StructType\SubGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubGroup) {
            throw new \InvalidArgumentException(sprintf('The SubGroup property can only contain items of \StructType\SubGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SubGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubGroup
     */
    public function getAttributeName()
    {
        return 'SubGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSubGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
