<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStreetInfoResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfStreetInfoResult extends AbstractStructArrayBase
{
    /**
     * The StreetInfoResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StreetInfoResult[]
     */
    public $StreetInfoResult;
    /**
     * Constructor method for ArrayOfStreetInfoResult
     * @uses ArrayOfStreetInfoResult::setStreetInfoResult()
     * @param \StructType\StreetInfoResult[] $streetInfoResult
     */
    public function __construct(array $streetInfoResult = array())
    {
        $this
            ->setStreetInfoResult($streetInfoResult);
    }
    /**
     * Get StreetInfoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StreetInfoResult[]|null
     */
    public function getStreetInfoResult()
    {
        return isset($this->StreetInfoResult) ? $this->StreetInfoResult : null;
    }
    /**
     * Set StreetInfoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StreetInfoResult[] $streetInfoResult
     * @return \ArrayType\ArrayOfStreetInfoResult
     */
    public function setStreetInfoResult(array $streetInfoResult = array())
    {
        foreach ($streetInfoResult as $arrayOfStreetInfoResultStreetInfoResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfStreetInfoResultStreetInfoResultItem instanceof \StructType\StreetInfoResult) {
                throw new \InvalidArgumentException(sprintf('The StreetInfoResult property can only contain items of \StructType\StreetInfoResult, "%s" given', is_object($arrayOfStreetInfoResultStreetInfoResultItem) ? get_class($arrayOfStreetInfoResultStreetInfoResultItem) : gettype($arrayOfStreetInfoResultStreetInfoResultItem)), __LINE__);
            }
        }
        if (is_null($streetInfoResult) || (is_array($streetInfoResult) && empty($streetInfoResult))) {
            unset($this->StreetInfoResult);
        } else {
            $this->StreetInfoResult = $streetInfoResult;
        }
        return $this;
    }
    /**
     * Add item to StreetInfoResult value
     * @throws \InvalidArgumentException
     * @param \StructType\StreetInfoResult $item
     * @return \ArrayType\ArrayOfStreetInfoResult
     */
    public function addToStreetInfoResult(\StructType\StreetInfoResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StreetInfoResult) {
            throw new \InvalidArgumentException(sprintf('The StreetInfoResult property can only contain items of \StructType\StreetInfoResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StreetInfoResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StreetInfoResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StreetInfoResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StreetInfoResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StreetInfoResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StreetInfoResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StreetInfoResult
     */
    public function getAttributeName()
    {
        return 'StreetInfoResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStreetInfoResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
