<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQuestionPathInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfQuestionPathInfo extends AbstractStructArrayBase
{
    /**
     * The QuestionPathInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QuestionPathInfo[]
     */
    public $QuestionPathInfo;
    /**
     * Constructor method for ArrayOfQuestionPathInfo
     * @uses ArrayOfQuestionPathInfo::setQuestionPathInfo()
     * @param \StructType\QuestionPathInfo[] $questionPathInfo
     */
    public function __construct(array $questionPathInfo = array())
    {
        $this
            ->setQuestionPathInfo($questionPathInfo);
    }
    /**
     * Get QuestionPathInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QuestionPathInfo[]|null
     */
    public function getQuestionPathInfo()
    {
        return isset($this->QuestionPathInfo) ? $this->QuestionPathInfo : null;
    }
    /**
     * Set QuestionPathInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionPathInfo[] $questionPathInfo
     * @return \ArrayType\ArrayOfQuestionPathInfo
     */
    public function setQuestionPathInfo(array $questionPathInfo = array())
    {
        foreach ($questionPathInfo as $arrayOfQuestionPathInfoQuestionPathInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfQuestionPathInfoQuestionPathInfoItem instanceof \StructType\QuestionPathInfo) {
                throw new \InvalidArgumentException(sprintf('The QuestionPathInfo property can only contain items of \StructType\QuestionPathInfo, "%s" given', is_object($arrayOfQuestionPathInfoQuestionPathInfoItem) ? get_class($arrayOfQuestionPathInfoQuestionPathInfoItem) : gettype($arrayOfQuestionPathInfoQuestionPathInfoItem)), __LINE__);
            }
        }
        if (is_null($questionPathInfo) || (is_array($questionPathInfo) && empty($questionPathInfo))) {
            unset($this->QuestionPathInfo);
        } else {
            $this->QuestionPathInfo = $questionPathInfo;
        }
        return $this;
    }
    /**
     * Add item to QuestionPathInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionPathInfo $item
     * @return \ArrayType\ArrayOfQuestionPathInfo
     */
    public function addToQuestionPathInfo(\StructType\QuestionPathInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionPathInfo) {
            throw new \InvalidArgumentException(sprintf('The QuestionPathInfo property can only contain items of \StructType\QuestionPathInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QuestionPathInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QuestionPathInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QuestionPathInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QuestionPathInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QuestionPathInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QuestionPathInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QuestionPathInfo
     */
    public function getAttributeName()
    {
        return 'QuestionPathInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfQuestionPathInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
