<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductInsert ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductInsert extends AbstractStructArrayBase
{
    /**
     * The ProductInsert
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductInsert[]
     */
    public $ProductInsert;
    /**
     * Constructor method for ArrayOfProductInsert
     * @uses ArrayOfProductInsert::setProductInsert()
     * @param \StructType\ProductInsert[] $productInsert
     */
    public function __construct(array $productInsert = array())
    {
        $this
            ->setProductInsert($productInsert);
    }
    /**
     * Get ProductInsert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductInsert[]|null
     */
    public function getProductInsert()
    {
        return isset($this->ProductInsert) ? $this->ProductInsert : null;
    }
    /**
     * Set ProductInsert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInsert[] $productInsert
     * @return \ArrayType\ArrayOfProductInsert
     */
    public function setProductInsert(array $productInsert = array())
    {
        foreach ($productInsert as $arrayOfProductInsertProductInsertItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductInsertProductInsertItem instanceof \StructType\ProductInsert) {
                throw new \InvalidArgumentException(sprintf('The ProductInsert property can only contain items of \StructType\ProductInsert, "%s" given', is_object($arrayOfProductInsertProductInsertItem) ? get_class($arrayOfProductInsertProductInsertItem) : gettype($arrayOfProductInsertProductInsertItem)), __LINE__);
            }
        }
        if (is_null($productInsert) || (is_array($productInsert) && empty($productInsert))) {
            unset($this->ProductInsert);
        } else {
            $this->ProductInsert = $productInsert;
        }
        return $this;
    }
    /**
     * Add item to ProductInsert value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInsert $item
     * @return \ArrayType\ArrayOfProductInsert
     */
    public function addToProductInsert(\StructType\ProductInsert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInsert) {
            throw new \InvalidArgumentException(sprintf('The ProductInsert property can only contain items of \StructType\ProductInsert, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductInsert[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductInsert|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductInsert|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductInsert|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductInsert|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductInsert|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductInsert
     */
    public function getAttributeName()
    {
        return 'ProductInsert';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
