<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlanningTripItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlanningTripItemResult extends AbstractStructArrayBase
{
    /**
     * The PlanningTripItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlanningTripItemResult[]
     */
    public $PlanningTripItemResult;
    /**
     * Constructor method for ArrayOfPlanningTripItemResult
     * @uses ArrayOfPlanningTripItemResult::setPlanningTripItemResult()
     * @param \StructType\PlanningTripItemResult[] $planningTripItemResult
     */
    public function __construct(array $planningTripItemResult = array())
    {
        $this
            ->setPlanningTripItemResult($planningTripItemResult);
    }
    /**
     * Get PlanningTripItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlanningTripItemResult[]|null
     */
    public function getPlanningTripItemResult()
    {
        return isset($this->PlanningTripItemResult) ? $this->PlanningTripItemResult : null;
    }
    /**
     * Set PlanningTripItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningTripItemResult[] $planningTripItemResult
     * @return \ArrayType\ArrayOfPlanningTripItemResult
     */
    public function setPlanningTripItemResult(array $planningTripItemResult = array())
    {
        foreach ($planningTripItemResult as $arrayOfPlanningTripItemResultPlanningTripItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlanningTripItemResultPlanningTripItemResultItem instanceof \StructType\PlanningTripItemResult) {
                throw new \InvalidArgumentException(sprintf('The PlanningTripItemResult property can only contain items of \StructType\PlanningTripItemResult, "%s" given', is_object($arrayOfPlanningTripItemResultPlanningTripItemResultItem) ? get_class($arrayOfPlanningTripItemResultPlanningTripItemResultItem) : gettype($arrayOfPlanningTripItemResultPlanningTripItemResultItem)), __LINE__);
            }
        }
        if (is_null($planningTripItemResult) || (is_array($planningTripItemResult) && empty($planningTripItemResult))) {
            unset($this->PlanningTripItemResult);
        } else {
            $this->PlanningTripItemResult = $planningTripItemResult;
        }
        return $this;
    }
    /**
     * Add item to PlanningTripItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningTripItemResult $item
     * @return \ArrayType\ArrayOfPlanningTripItemResult
     */
    public function addToPlanningTripItemResult(\StructType\PlanningTripItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningTripItemResult) {
            throw new \InvalidArgumentException(sprintf('The PlanningTripItemResult property can only contain items of \StructType\PlanningTripItemResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlanningTripItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlanningTripItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlanningTripItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlanningTripItemResult
     */
    public function getAttributeName()
    {
        return 'PlanningTripItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlanningTripItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
