<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceItemResult_V6 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceItemResult_V6 extends AbstractStructArrayBase
{
    /**
     * The PlaceItemResult_V6
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceItemResult_V6[]
     */
    public $PlaceItemResult_V6;
    /**
     * Constructor method for ArrayOfPlaceItemResult_V6
     * @uses ArrayOfPlaceItemResult_V6::setPlaceItemResult_V6()
     * @param \StructType\PlaceItemResult_V6[] $placeItemResult_V6
     */
    public function __construct(array $placeItemResult_V6 = array())
    {
        $this
            ->setPlaceItemResult_V6($placeItemResult_V6);
    }
    /**
     * Get PlaceItemResult_V6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceItemResult_V6[]|null
     */
    public function getPlaceItemResult_V6()
    {
        return isset($this->PlaceItemResult_V6) ? $this->PlaceItemResult_V6 : null;
    }
    /**
     * Set PlaceItemResult_V6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult_V6[] $placeItemResult_V6
     * @return \ArrayType\ArrayOfPlaceItemResult_V6
     */
    public function setPlaceItemResult_V6(array $placeItemResult_V6 = array())
    {
        foreach ($placeItemResult_V6 as $arrayOfPlaceItemResult_V6PlaceItemResult_V6Item) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceItemResult_V6PlaceItemResult_V6Item instanceof \StructType\PlaceItemResult_V6) {
                throw new \InvalidArgumentException(sprintf('The PlaceItemResult_V6 property can only contain items of \StructType\PlaceItemResult_V6, "%s" given', is_object($arrayOfPlaceItemResult_V6PlaceItemResult_V6Item) ? get_class($arrayOfPlaceItemResult_V6PlaceItemResult_V6Item) : gettype($arrayOfPlaceItemResult_V6PlaceItemResult_V6Item)), __LINE__);
            }
        }
        if (is_null($placeItemResult_V6) || (is_array($placeItemResult_V6) && empty($placeItemResult_V6))) {
            unset($this->PlaceItemResult_V6);
        } else {
            $this->PlaceItemResult_V6 = $placeItemResult_V6;
        }
        return $this;
    }
    /**
     * Add item to PlaceItemResult_V6 value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult_V6 $item
     * @return \ArrayType\ArrayOfPlaceItemResult_V6
     */
    public function addToPlaceItemResult_V6(\StructType\PlaceItemResult_V6 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceItemResult_V6) {
            throw new \InvalidArgumentException(sprintf('The PlaceItemResult_V6 property can only contain items of \StructType\PlaceItemResult_V6, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceItemResult_V6[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceItemResult_V6|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceItemResult_V6|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceItemResult_V6|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceItemResult_V6|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceItemResult_V6|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceItemResult_V6
     */
    public function getAttributeName()
    {
        return 'PlaceItemResult_V6';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlaceItemResult_V6
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
