<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceIdentifier extends AbstractStructArrayBase
{
    /**
     * The PlaceIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceIdentifier[]
     */
    public $PlaceIdentifier;
    /**
     * Constructor method for ArrayOfPlaceIdentifier
     * @uses ArrayOfPlaceIdentifier::setPlaceIdentifier()
     * @param \StructType\PlaceIdentifier[] $placeIdentifier
     */
    public function __construct(array $placeIdentifier = array())
    {
        $this
            ->setPlaceIdentifier($placeIdentifier);
    }
    /**
     * Get PlaceIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceIdentifier[]|null
     */
    public function getPlaceIdentifier()
    {
        return isset($this->PlaceIdentifier) ? $this->PlaceIdentifier : null;
    }
    /**
     * Set PlaceIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceIdentifier[] $placeIdentifier
     * @return \ArrayType\ArrayOfPlaceIdentifier
     */
    public function setPlaceIdentifier(array $placeIdentifier = array())
    {
        foreach ($placeIdentifier as $arrayOfPlaceIdentifierPlaceIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceIdentifierPlaceIdentifierItem instanceof \StructType\PlaceIdentifier) {
                throw new \InvalidArgumentException(sprintf('The PlaceIdentifier property can only contain items of \StructType\PlaceIdentifier, "%s" given', is_object($arrayOfPlaceIdentifierPlaceIdentifierItem) ? get_class($arrayOfPlaceIdentifierPlaceIdentifierItem) : gettype($arrayOfPlaceIdentifierPlaceIdentifierItem)), __LINE__);
            }
        }
        if (is_null($placeIdentifier) || (is_array($placeIdentifier) && empty($placeIdentifier))) {
            unset($this->PlaceIdentifier);
        } else {
            $this->PlaceIdentifier = $placeIdentifier;
        }
        return $this;
    }
    /**
     * Add item to PlaceIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceIdentifier $item
     * @return \ArrayType\ArrayOfPlaceIdentifier
     */
    public function addToPlaceIdentifier(\StructType\PlaceIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceIdentifier) {
            throw new \InvalidArgumentException(sprintf('The PlaceIdentifier property can only contain items of \StructType\PlaceIdentifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceIdentifier
     */
    public function getAttributeName()
    {
        return 'PlaceIdentifier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlaceIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
