<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult_V2 extends AbstractStructArrayBase
{
    /**
     * The PersonResult_V2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult_V2[]
     */
    public $PersonResult_V2;
    /**
     * Constructor method for ArrayOfPersonResult_V2
     * @uses ArrayOfPersonResult_V2::setPersonResult_V2()
     * @param \StructType\PersonResult_V2[] $personResult_V2
     */
    public function __construct(array $personResult_V2 = array())
    {
        $this
            ->setPersonResult_V2($personResult_V2);
    }
    /**
     * Get PersonResult_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult_V2[]|null
     */
    public function getPersonResult_V2()
    {
        return isset($this->PersonResult_V2) ? $this->PersonResult_V2 : null;
    }
    /**
     * Set PersonResult_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V2[] $personResult_V2
     * @return \ArrayType\ArrayOfPersonResult_V2
     */
    public function setPersonResult_V2(array $personResult_V2 = array())
    {
        foreach ($personResult_V2 as $arrayOfPersonResult_V2PersonResult_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResult_V2PersonResult_V2Item instanceof \StructType\PersonResult_V2) {
                throw new \InvalidArgumentException(sprintf('The PersonResult_V2 property can only contain items of \StructType\PersonResult_V2, "%s" given', is_object($arrayOfPersonResult_V2PersonResult_V2Item) ? get_class($arrayOfPersonResult_V2PersonResult_V2Item) : gettype($arrayOfPersonResult_V2PersonResult_V2Item)), __LINE__);
            }
        }
        if (is_null($personResult_V2) || (is_array($personResult_V2) && empty($personResult_V2))) {
            unset($this->PersonResult_V2);
        } else {
            $this->PersonResult_V2 = $personResult_V2;
        }
        return $this;
    }
    /**
     * Add item to PersonResult_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V2 $item
     * @return \ArrayType\ArrayOfPersonResult_V2
     */
    public function addToPersonResult_V2(\StructType\PersonResult_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult_V2) {
            throw new \InvalidArgumentException(sprintf('The PersonResult_V2 property can only contain items of \StructType\PersonResult_V2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonResult_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult_V2
     */
    public function getAttributeName()
    {
        return 'PersonResult_V2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPersonResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
