<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPOIResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPOIResult extends AbstractStructArrayBase
{
    /**
     * The POIResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\POIResult[]
     */
    public $POIResult;
    /**
     * Constructor method for ArrayOfPOIResult
     * @uses ArrayOfPOIResult::setPOIResult()
     * @param \StructType\POIResult[] $pOIResult
     */
    public function __construct(array $pOIResult = array())
    {
        $this
            ->setPOIResult($pOIResult);
    }
    /**
     * Get POIResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\POIResult[]|null
     */
    public function getPOIResult()
    {
        return isset($this->POIResult) ? $this->POIResult : null;
    }
    /**
     * Set POIResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\POIResult[] $pOIResult
     * @return \ArrayType\ArrayOfPOIResult
     */
    public function setPOIResult(array $pOIResult = array())
    {
        foreach ($pOIResult as $arrayOfPOIResultPOIResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPOIResultPOIResultItem instanceof \StructType\POIResult) {
                throw new \InvalidArgumentException(sprintf('The POIResult property can only contain items of \StructType\POIResult, "%s" given', is_object($arrayOfPOIResultPOIResultItem) ? get_class($arrayOfPOIResultPOIResultItem) : gettype($arrayOfPOIResultPOIResultItem)), __LINE__);
            }
        }
        if (is_null($pOIResult) || (is_array($pOIResult) && empty($pOIResult))) {
            unset($this->POIResult);
        } else {
            $this->POIResult = $pOIResult;
        }
        return $this;
    }
    /**
     * Add item to POIResult value
     * @throws \InvalidArgumentException
     * @param \StructType\POIResult $item
     * @return \ArrayType\ArrayOfPOIResult
     */
    public function addToPOIResult(\StructType\POIResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\POIResult) {
            throw new \InvalidArgumentException(sprintf('The POIResult property can only contain items of \StructType\POIResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->POIResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\POIResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\POIResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\POIResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\POIResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\POIResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string POIResult
     */
    public function getAttributeName()
    {
        return 'POIResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPOIResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
