<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapPosition ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapPosition extends AbstractStructArrayBase
{
    /**
     * The MapPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapPosition[]
     */
    public $MapPosition;
    /**
     * Constructor method for ArrayOfMapPosition
     * @uses ArrayOfMapPosition::setMapPosition()
     * @param \StructType\MapPosition[] $mapPosition
     */
    public function __construct(array $mapPosition = array())
    {
        $this
            ->setMapPosition($mapPosition);
    }
    /**
     * Get MapPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapPosition[]|null
     */
    public function getMapPosition()
    {
        return isset($this->MapPosition) ? $this->MapPosition : null;
    }
    /**
     * Set MapPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition[] $mapPosition
     * @return \ArrayType\ArrayOfMapPosition
     */
    public function setMapPosition(array $mapPosition = array())
    {
        foreach ($mapPosition as $arrayOfMapPositionMapPositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapPositionMapPositionItem instanceof \StructType\MapPosition) {
                throw new \InvalidArgumentException(sprintf('The MapPosition property can only contain items of \StructType\MapPosition, "%s" given', is_object($arrayOfMapPositionMapPositionItem) ? get_class($arrayOfMapPositionMapPositionItem) : gettype($arrayOfMapPositionMapPositionItem)), __LINE__);
            }
        }
        if (is_null($mapPosition) || (is_array($mapPosition) && empty($mapPosition))) {
            unset($this->MapPosition);
        } else {
            $this->MapPosition = $mapPosition;
        }
        return $this;
    }
    /**
     * Add item to MapPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition $item
     * @return \ArrayType\ArrayOfMapPosition
     */
    public function addToMapPosition(\StructType\MapPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapPosition) {
            throw new \InvalidArgumentException(sprintf('The MapPosition property can only contain items of \StructType\MapPosition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MapPosition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapPosition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapPosition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapPosition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapPosition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapPosition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapPosition
     */
    public function getAttributeName()
    {
        return 'MapPosition';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMapPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
