<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapItem extends AbstractStructArrayBase
{
    /**
     * The MapItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapItem[]
     */
    public $MapItem;
    /**
     * Constructor method for ArrayOfMapItem
     * @uses ArrayOfMapItem::setMapItem()
     * @param \StructType\MapItem[] $mapItem
     */
    public function __construct(array $mapItem = array())
    {
        $this
            ->setMapItem($mapItem);
    }
    /**
     * Get MapItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapItem[]|null
     */
    public function getMapItem()
    {
        return isset($this->MapItem) ? $this->MapItem : null;
    }
    /**
     * Set MapItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem[] $mapItem
     * @return \ArrayType\ArrayOfMapItem
     */
    public function setMapItem(array $mapItem = array())
    {
        foreach ($mapItem as $arrayOfMapItemMapItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapItemMapItemItem instanceof \StructType\MapItem) {
                throw new \InvalidArgumentException(sprintf('The MapItem property can only contain items of \StructType\MapItem, "%s" given', is_object($arrayOfMapItemMapItemItem) ? get_class($arrayOfMapItemMapItemItem) : gettype($arrayOfMapItemMapItemItem)), __LINE__);
            }
        }
        if (is_null($mapItem) || (is_array($mapItem) && empty($mapItem))) {
            unset($this->MapItem);
        } else {
            $this->MapItem = $mapItem;
        }
        return $this;
    }
    /**
     * Add item to MapItem value
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem $item
     * @return \ArrayType\ArrayOfMapItem
     */
    public function addToMapItem(\StructType\MapItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapItem) {
            throw new \InvalidArgumentException(sprintf('The MapItem property can only contain items of \StructType\MapItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MapItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapItem
     */
    public function getAttributeName()
    {
        return 'MapItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMapItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
