<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobItemResult_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobItemResult_V2 extends AbstractStructArrayBase
{
    /**
     * The JobItemResult_V2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobItemResult_V2[]
     */
    public $JobItemResult_V2;
    /**
     * Constructor method for ArrayOfJobItemResult_V2
     * @uses ArrayOfJobItemResult_V2::setJobItemResult_V2()
     * @param \StructType\JobItemResult_V2[] $jobItemResult_V2
     */
    public function __construct(array $jobItemResult_V2 = array())
    {
        $this
            ->setJobItemResult_V2($jobItemResult_V2);
    }
    /**
     * Get JobItemResult_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobItemResult_V2[]|null
     */
    public function getJobItemResult_V2()
    {
        return isset($this->JobItemResult_V2) ? $this->JobItemResult_V2 : null;
    }
    /**
     * Set JobItemResult_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V2[] $jobItemResult_V2
     * @return \ArrayType\ArrayOfJobItemResult_V2
     */
    public function setJobItemResult_V2(array $jobItemResult_V2 = array())
    {
        foreach ($jobItemResult_V2 as $arrayOfJobItemResult_V2JobItemResult_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfJobItemResult_V2JobItemResult_V2Item instanceof \StructType\JobItemResult_V2) {
                throw new \InvalidArgumentException(sprintf('The JobItemResult_V2 property can only contain items of \StructType\JobItemResult_V2, "%s" given', is_object($arrayOfJobItemResult_V2JobItemResult_V2Item) ? get_class($arrayOfJobItemResult_V2JobItemResult_V2Item) : gettype($arrayOfJobItemResult_V2JobItemResult_V2Item)), __LINE__);
            }
        }
        if (is_null($jobItemResult_V2) || (is_array($jobItemResult_V2) && empty($jobItemResult_V2))) {
            unset($this->JobItemResult_V2);
        } else {
            $this->JobItemResult_V2 = $jobItemResult_V2;
        }
        return $this;
    }
    /**
     * Add item to JobItemResult_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V2 $item
     * @return \ArrayType\ArrayOfJobItemResult_V2
     */
    public function addToJobItemResult_V2(\StructType\JobItemResult_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobItemResult_V2) {
            throw new \InvalidArgumentException(sprintf('The JobItemResult_V2 property can only contain items of \StructType\JobItemResult_V2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobItemResult_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobItemResult_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobItemResult_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobItemResult_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobItemResult_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobItemResult_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobItemResult_V2
     */
    public function getAttributeName()
    {
        return 'JobItemResult_V2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJobItemResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
