<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobIdentifier extends AbstractStructArrayBase
{
    /**
     * The JobIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobIdentifier[]
     */
    public $JobIdentifier;
    /**
     * Constructor method for ArrayOfJobIdentifier
     * @uses ArrayOfJobIdentifier::setJobIdentifier()
     * @param \StructType\JobIdentifier[] $jobIdentifier
     */
    public function __construct(array $jobIdentifier = array())
    {
        $this
            ->setJobIdentifier($jobIdentifier);
    }
    /**
     * Get JobIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobIdentifier[]|null
     */
    public function getJobIdentifier()
    {
        return isset($this->JobIdentifier) ? $this->JobIdentifier : null;
    }
    /**
     * Set JobIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobIdentifier[] $jobIdentifier
     * @return \ArrayType\ArrayOfJobIdentifier
     */
    public function setJobIdentifier(array $jobIdentifier = array())
    {
        foreach ($jobIdentifier as $arrayOfJobIdentifierJobIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobIdentifierJobIdentifierItem instanceof \StructType\JobIdentifier) {
                throw new \InvalidArgumentException(sprintf('The JobIdentifier property can only contain items of \StructType\JobIdentifier, "%s" given', is_object($arrayOfJobIdentifierJobIdentifierItem) ? get_class($arrayOfJobIdentifierJobIdentifierItem) : gettype($arrayOfJobIdentifierJobIdentifierItem)), __LINE__);
            }
        }
        if (is_null($jobIdentifier) || (is_array($jobIdentifier) && empty($jobIdentifier))) {
            unset($this->JobIdentifier);
        } else {
            $this->JobIdentifier = $jobIdentifier;
        }
        return $this;
    }
    /**
     * Add item to JobIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\JobIdentifier $item
     * @return \ArrayType\ArrayOfJobIdentifier
     */
    public function addToJobIdentifier(\StructType\JobIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobIdentifier) {
            throw new \InvalidArgumentException(sprintf('The JobIdentifier property can only contain items of \StructType\JobIdentifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobIdentifier
     */
    public function getAttributeName()
    {
        return 'JobIdentifier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJobIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
