<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInfoFieldItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfInfoFieldItem extends AbstractStructArrayBase
{
    /**
     * The InfoFieldItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InfoFieldItem[]
     */
    public $InfoFieldItem;
    /**
     * Constructor method for ArrayOfInfoFieldItem
     * @uses ArrayOfInfoFieldItem::setInfoFieldItem()
     * @param \StructType\InfoFieldItem[] $infoFieldItem
     */
    public function __construct(array $infoFieldItem = array())
    {
        $this
            ->setInfoFieldItem($infoFieldItem);
    }
    /**
     * Get InfoFieldItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InfoFieldItem[]|null
     */
    public function getInfoFieldItem()
    {
        return isset($this->InfoFieldItem) ? $this->InfoFieldItem : null;
    }
    /**
     * Set InfoFieldItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InfoFieldItem[] $infoFieldItem
     * @return \ArrayType\ArrayOfInfoFieldItem
     */
    public function setInfoFieldItem(array $infoFieldItem = array())
    {
        foreach ($infoFieldItem as $arrayOfInfoFieldItemInfoFieldItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfInfoFieldItemInfoFieldItemItem instanceof \StructType\InfoFieldItem) {
                throw new \InvalidArgumentException(sprintf('The InfoFieldItem property can only contain items of \StructType\InfoFieldItem, "%s" given', is_object($arrayOfInfoFieldItemInfoFieldItemItem) ? get_class($arrayOfInfoFieldItemInfoFieldItemItem) : gettype($arrayOfInfoFieldItemInfoFieldItemItem)), __LINE__);
            }
        }
        if (is_null($infoFieldItem) || (is_array($infoFieldItem) && empty($infoFieldItem))) {
            unset($this->InfoFieldItem);
        } else {
            $this->InfoFieldItem = $infoFieldItem;
        }
        return $this;
    }
    /**
     * Add item to InfoFieldItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoFieldItem $item
     * @return \ArrayType\ArrayOfInfoFieldItem
     */
    public function addToInfoFieldItem(\StructType\InfoFieldItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoFieldItem) {
            throw new \InvalidArgumentException(sprintf('The InfoFieldItem property can only contain items of \StructType\InfoFieldItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoFieldItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InfoFieldItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InfoFieldItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InfoFieldItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InfoFieldItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InfoFieldItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InfoFieldItem
     */
    public function getAttributeName()
    {
        return 'InfoFieldItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInfoFieldItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
