<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierPlace ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierPlace extends AbstractStructArrayBase
{
    /**
     * The IdentifierPlace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierPlace[]
     */
    public $IdentifierPlace;
    /**
     * Constructor method for ArrayOfIdentifierPlace
     * @uses ArrayOfIdentifierPlace::setIdentifierPlace()
     * @param \StructType\IdentifierPlace[] $identifierPlace
     */
    public function __construct(array $identifierPlace = array())
    {
        $this
            ->setIdentifierPlace($identifierPlace);
    }
    /**
     * Get IdentifierPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierPlace[]|null
     */
    public function getIdentifierPlace()
    {
        return isset($this->IdentifierPlace) ? $this->IdentifierPlace : null;
    }
    /**
     * Set IdentifierPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierPlace[] $identifierPlace
     * @return \ArrayType\ArrayOfIdentifierPlace
     */
    public function setIdentifierPlace(array $identifierPlace = array())
    {
        foreach ($identifierPlace as $arrayOfIdentifierPlaceIdentifierPlaceItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierPlaceIdentifierPlaceItem instanceof \StructType\IdentifierPlace) {
                throw new \InvalidArgumentException(sprintf('The IdentifierPlace property can only contain items of \StructType\IdentifierPlace, "%s" given', is_object($arrayOfIdentifierPlaceIdentifierPlaceItem) ? get_class($arrayOfIdentifierPlaceIdentifierPlaceItem) : gettype($arrayOfIdentifierPlaceIdentifierPlaceItem)), __LINE__);
            }
        }
        if (is_null($identifierPlace) || (is_array($identifierPlace) && empty($identifierPlace))) {
            unset($this->IdentifierPlace);
        } else {
            $this->IdentifierPlace = $identifierPlace;
        }
        return $this;
    }
    /**
     * Add item to IdentifierPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierPlace $item
     * @return \ArrayType\ArrayOfIdentifierPlace
     */
    public function addToIdentifierPlace(\StructType\IdentifierPlace $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierPlace) {
            throw new \InvalidArgumentException(sprintf('The IdentifierPlace property can only contain items of \StructType\IdentifierPlace, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IdentifierPlace[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierPlace|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierPlace|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierPlace|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierPlace|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierPlace|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierPlace
     */
    public function getAttributeName()
    {
        return 'IdentifierPlace';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIdentifierPlace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
